import wave
import math
import struct

bitrate = 44100

#creating a new sound file

sound = wave.open('Tone.wav','w')
sound.setparams((1,2,bitrate,0,'NONE','not compressed'))

#writing each sample

def addTone(frequency, secs):
    
    numberOfSamples = int(secs*bitrate)
    
    for x in range(numberOfSamples):
        #This bit just tells you how far through you are
        
        if x%4000 ==0:
            print(str(x)+' of '+str(numberOfSamples)+' generated for '+str(frequency)+'Hz sound.')
            
        #this generates the point of a sound sine wave knowing where in the sound it is due to for loop.
        #This is A Level Maths - please don't worry if you don't understand it!
        
        point = int(math.sin((x/bitrate)*2*math.pi*frequency)*(2**14))

        #this packs the point into the sound file
        
        packed = struct.pack('h',point)
        sound.writeframes(packed)

def addTwoTone(f1, f2, secs):
    numberOfSamples = int(secs*bitrate)
    for x in range(numberOfSamples):
        if x%4000 ==0:
            print(str(x)+' of '+str(numberOfSamples)+' samples generated for '+str(f1)+'/'+str(f2)+'Hz sound.')
        
        point = int(math.sin((x/bitrate)*2*math.pi*f1)*(2**14)) + int(math.sin((x/bitrate)*2*math.pi*f2)*(2**14))
        
        packed = struct.pack('h',point)
        sound.writeframes(packed)    

#add your sound waves here: addTone(frequency, time)
# e.g. addTone(440,0.2)








sound.close()


